/* 
------------------------------------------------------------------------------------------------------------------------------

   Auteur :   A4 Technologie
   Date :     06/02/2015
   Fichier :  Barriere_sequence_3.INO
   Document : Dossier barrière de parking (D-APARK)
   Objectif : Ajouter un contrôle de sécurité à la fermeture de la barrière
  
------------------------------------------------------------------------------------------------------------------------------

Connexion de l’interface AutoProgUno (Arduino) à la maquette :

  Module capteur	Variable Arduino	Broche AutoProg Uno

Bouton poussoir/RFID      bouton_poussoir                A4
Récepteur infrarouge	   recepteur_IR                  A5
Fin de course fermeture	   fdc_fermeture	          3
Fin de course ouverture	   fdc_ouverture	          2


Module actionneur	Variable Arduino	Broche AutoProg Uno

Module Gyrophare	    gyrophare	                  4
Emetteur infrarouge	    emetteur_IR                   5
Moteur                        moteur                      6            
ouverture/fermeture		

------------------------------------------------------------------------------------------------------------------------------
*/


//Définition des variables, constantes et pin :

// Pin d'entrées

const int fdc_fermeture   = 3; 
const int fdc_ouverture   = 2; 
const int bouton_poussoir = A4;
const int recepteur_IR    = A5;


//Pin de sorties
const int gyrophare     = 4; 
const int emetteur_IR   = 5; 
const int moteur        = 6; 


//Initialisation

void setup()
{
     
    //paramètrage des pins en entrée/sortie
    
    // Définition des pins comme des entrées

    pinMode (fdc_fermeture, INPUT);
    pinMode (fdc_ouverture, INPUT);
    pinMode (bouton_poussoir, INPUT);
    pinMode (recepteur_IR, INPUT);
   
    // Définition des pins comme des sorties
    pinMode (gyrophare, OUTPUT);
    pinMode (emetteur_IR, OUTPUT);
    pinMode (moteur, OUTPUT);
  
}



//Programme principal
//Boucle infinie
void loop()
{
 digitalWrite(emetteur_IR,HIGH); // Activation de la barrière infrarouge
 
 if (digitalRead(bouton_poussoir)==HIGH)   //Si le bouton poussoir/RFID activé
 {  
  ouverture_barriere();// Aller dans la fonctions ouverture_barriere
   
  delay(3000); // Attendre 3 secondes
     
  fermeture_barriere();// Aller dans la fonctions ouverture_barriere   
 }   
} 
// Fin du Programme principal

//Fonctions

void ouverture_barriere()// Fonction ouverture de la barriere
{
     while (digitalRead(fdc_ouverture)==LOW)//Exécuter les commandes tant que fdc_ouverture est désactivé
     {
       digitalWrite(moteur,HIGH);// Marche du moteur (ouverture de la barrière
       digitalWrite(gyrophare,HIGH);// Activation du gyrophare
       delay(100);
       digitalWrite(gyrophare,LOW);// Désactivation du gyrophare
       delay(100);       
     }
     digitalWrite(moteur,LOW); // Arrêt du moteur
}

void fermeture_barriere()// Fonction fermeture de la barriere
{
     while (digitalRead(fdc_fermeture)==LOW) //Exécuter les commandes tant que fdc_fermeture est désactivé
     {
       while (digitalRead(recepteur_IR)==HIGH)// Tant que la détection infrarouge est activée
       {
         digitalWrite(moteur,LOW); // Arrêt du moteur si un obstacle est détecté
       }           
       digitalWrite(moteur,HIGH); // Marche du moteur (fermeture de la barrière)
       digitalWrite(gyrophare,HIGH);// Activation du gyrophare
       delay(100);
       digitalWrite(gyrophare,LOW);// Désactivation du gyrophare
       delay(100);            
     }
     digitalWrite(moteur,LOW); // Arrêt du moteur
}     


